<?php
/*
Plugin Name: Simple Backup SaaS
*/

add_action('admin_menu', function () {
    add_menu_page('Backup SaaS', 'Backup SaaS', 'manage_options', 'backup-saas', 'backup_saas_page');
});

function backup_saas_page() {
    if (isset($_POST['run_backup'])) {
        backup_saas_run();
    }

    ?>
    <form method="post">
        <label>API URL</label><br>
        <input type="text" name="api_url" value="<?= esc_attr(get_option('backup_api_url')) ?>"><br>

        <label>API Key</label><br>
        <input type="text" name="api_key" value="<?= esc_attr(get_option('backup_api_key')) ?>"><br>

        <button name="save">Save</button>
        <button name="run_backup">Run Backup Now</button>
    </form>
    <?php

    if (isset($_POST['save'])) {
        update_option('backup_api_url', $_POST['api_url']);
        update_option('backup_api_key', $_POST['api_key']);
        echo "Saved";
    }
}

function backup_saas_run() {
    global $wpdb;

    $upload_dir = wp_upload_dir()['basedir'] . '/backup-temp';
    @mkdir($upload_dir);

    // ZIP wp-content
    $zip_file = "$upload_dir/files.zip";
    exec("zip -r $zip_file " . WP_CONTENT_DIR . " -x '*cache*'");

    // DB dump
    $db_file = "$upload_dir/db.sql";
    $gz_file = "$upload_dir/db.sql.gz";

    exec("mysqldump -u" . DB_USER . " -p" . DB_PASSWORD . " " . DB_NAME . " > $db_file");
    exec("gzip $db_file");

    // Upload
    $ch = curl_init(get_option('backup_api_url') . '/upload.php');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, [
        'site_id' => home_url(),
        'api_key' => get_option('backup_api_key'),
        'files_zip' => new CURLFile($zip_file),
        'db_dump' => new CURLFile($gz_file),
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    echo "<pre>$response</pre>";
}

// Daily cron
if (!wp_next_scheduled('backup_saas_daily')) {
    wp_schedule_event(time(), 'daily', 'backup_saas_daily');
}
add_action('backup_saas_daily', 'backup_saas_run');
